--[[

Author:	PeterAH
Edit:	Bremi456

]]
MBtrac = {}

local _modDirectory = g_currentModDirectory

function MBtrac.prerequisitesPresent(specializations)
    return true
end

--function MBtrac.initSpecialization()
--    local schema = Vehicle.xmlSchema
--    schema:setXMLSpecializationType("MBtrac")
--    schema:setXMLSpecializationType()
--end

function MBtrac.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", MBtrac)
	SpecializationUtil.registerEventListener(vehicleType, "onStartMotor", MBtrac)
    SpecializationUtil.registerEventListener(vehicleType, "onStopMotor", MBtrac)
	SpecializationUtil.registerEventListener(vehicleType, "onGearGroupChanged", MBtrac)
end

function MBtrac:onLoad(savegame)
	self.splitGearIconLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.mbtrac.splitGearIconLight#node"), self.i3dMappings)
	
	self.gearGroupTransmissionSound1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.mbtrac.gearGroupTransmissionSound1#node"), self.i3dMappings)
    self.gearGroupTransmissionSound2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.mbtrac.gearGroupTransmissionSound2#node"), self.i3dMappings)
	
	self.gearLeverSplitter = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.mbtrac.gearLeverSplitter#node"), self.i3dMappings)
	
    setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
    setTranslation(self.gearGroupTransmissionSound2,0,-100,0 )
	
	self.gearGroupState = 0
    self.gearGroupStateBackup = 0
end

function MBtrac:onStartMotor()
    if self.gearGroupState < 2 then
        setTranslation(self.gearGroupTransmissionSound1,0,0.85,0)
        setTranslation(self.gearGroupTransmissionSound2,0,-100,0)
		
		setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 1, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0.45, 0, 0, 0, false)
		setTranslation(self.gearLeverSplitter,0,0,0)
    elseif self.gearGroupState == 2 then
        setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
        setTranslation(self.gearGroupTransmissionSound2,0,0.85,0)
		
		setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 0, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0, 0, 0, 0, false)
		setTranslation(self.gearLeverSplitter,0,0.011,0)
    elseif self.gearGroupState == 3 then
        setTranslation(self.gearGroupTransmissionSound1,0,0.85,0)
        setTranslation(self.gearGroupTransmissionSound2,0,-100,0)
		
		setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 1, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0.45, 0, 0, 0, false)
		setTranslation(self.gearLeverSplitter,0,0,0)
    elseif self.gearGroupState == 4 then
        setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
        setTranslation(self.gearGroupTransmissionSound2,0,0.85,0)
		
		setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 0, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0, 0, 0, 0, false)
		setTranslation(self.gearLeverSplitter,0,0.011,0)
    end
end

function MBtrac:onStopMotor()	
	setShaderParameter(self.splitGearIconLightNode, "emitColor", 1, 0, 0, 0, false)
    setShaderParameter(self.splitGearIconLightNode, "lightControl", 0, 0, 0, 0, false)
	
	setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
    setTranslation(self.gearGroupTransmissionSound2,0,-100,0 )
end

function MBtrac:onGearGroupChanged(targetGroup, changeTime)


    self.gearGroupState = targetGroup

    
    if self.gearGroupStateBackup ~= self.gearGroupState and self.spec_motorized.isMotorStarted then
        if self.gearGroupState < 2 then
            setTranslation(self.gearGroupTransmissionSound1,0,0.85,0)
			setTranslation(self.gearGroupTransmissionSound2,0,-100,0)
			
			setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 1, false)
			setShaderParameter(self.splitGearIconLightNode, "lightControl", 0.45, 0, 0, 0, false)
			setTranslation(self.gearLeverSplitter,0,0,0)
        elseif self.gearGroupState == 2 then
            setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
			setTranslation(self.gearGroupTransmissionSound2,0,0.85,0)
			
			setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 0, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0, 0, 0, 0, false)
			setTranslation(self.gearLeverSplitter,0,0.011,0)
        elseif self.gearGroupState == 3 then
            setTranslation(self.gearGroupTransmissionSound1,0,0.85,0)
			setTranslation(self.gearGroupTransmissionSound2,0,-100,0)
			
			setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 1, false)
			setShaderParameter(self.splitGearIconLightNode, "lightControl", 0.45, 0, 0, 0, false)
			setTranslation(self.gearLeverSplitter,0,0,0)
        elseif self.gearGroupState == 4 then
            setTranslation(self.gearGroupTransmissionSound1,0,-100,0)
			setTranslation(self.gearGroupTransmissionSound2,0,0.85,0)
			
			setShaderParameter(self.splitGearIconLightNode, "emitColor", 0, 1, 0, 0, false)
		setShaderParameter(self.splitGearIconLightNode, "lightControl", 0, 0, 0, 0, false)
			setTranslation(self.gearLeverSplitter,0,0.011,0)
        end
    end
    self.gearGroupStateBackup = self.gearGroupState
    
end
